% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AIC.sbm.r
\name{AIC.sbm}
\alias{AIC.sbm}
\title{Get AIC of size biased model}
\usage{
\method{AIC}{sbm}(object, ..., k = 2)
}
\arguments{
\item{object}{A size biased distribution model of class \code{sbm}.}

\item{...}{Optional additional \code{sbm} objects.}

\item{k}{Numeric, the penalty per parameter to be used; the default k = 2
is the classical AIC.}
}
\value{
A dataframe of AIC values, NA if the model is non-parametric
 (i.e. fitted with \code{pdf = "none"}).
}
\description{
Extracts the Akaike Information Criterion from a fitted parametric size
biased distribution model.
}
\examples{
  data(BCI_speed_data)
  lmod_null <- sbm(speed~1, BCI_speed_data, pdf="lnorm")
  lmod_mass <- sbm(speed~mass, BCI_speed_data, pdf="lnorm")
  AIC(lmod_null, lmod_mass)
}
