% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/label-currency.R
\name{dollar_format}
\alias{dollar_format}
\alias{dollar}
\alias{label_dollar}
\title{Superseded interface to \code{label_currency()}}
\usage{
dollar_format(
  accuracy = NULL,
  scale = 1,
  prefix = "$",
  suffix = "",
  big.mark = ",",
  decimal.mark = ".",
  trim = TRUE,
  largest_with_cents = 1e+05,
  negative_parens = deprecated(),
  ...
)

dollar(
  x,
  accuracy = NULL,
  scale = 1,
  prefix = NULL,
  suffix = NULL,
  big.mark = NULL,
  decimal.mark = NULL,
  trim = TRUE,
  largest_with_cents = 1e+05,
  negative_parens = deprecated(),
  style_negative = c("hyphen", "minus", "parens"),
  scale_cut = NULL,
  ...
)

label_dollar(
  accuracy = NULL,
  scale = 1,
  prefix = "$",
  suffix = "",
  big.mark = ",",
  decimal.mark = ".",
  trim = TRUE,
  largest_with_cents = 1e+05,
  negative_parens = deprecated(),
  ...
)
}
\arguments{
\item{scale}{A scaling factor: \code{x} will be multiplied by \code{scale} before
formatting. This is useful if the underlying data is very small or very
large.}

\item{prefix, suffix}{Symbols to display before and after value.}

\item{big.mark}{Character used between every 3 digits to separate thousands.
The default (\code{NULL}) retrieves the setting from the
\link[=number_options]{number options}.}

\item{decimal.mark}{The character to be used to indicate the numeric
decimal point.  The default (\code{NULL}) retrieves the setting from the
\link[=number_options]{number options}.}

\item{trim}{Logical, if \code{FALSE}, values are right-justified to a common
width (see \code{\link[base:format]{base::format()}}).}

\item{largest_with_cents}{Like \code{largest_with_fractional()} in
\code{\link[=label_currency]{label_currency()}}}

\item{negative_parens}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} Use
\code{style_negative = "parens"} instead.}

\item{...}{Other arguments passed on to \code{\link[base:format]{base::format()}}.}

\item{x}{A numeric vector}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#superseded}{\figure{lifecycle-superseded.svg}{options: alt='[Superseded]'}}}{\strong{[Superseded]}}

These functions are kept for backward compatibility; you should switch
to \code{\link[=label_currency]{label_currency()}} for new code.
}
\keyword{internal}
