% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scat.h.R
\name{scat}
\alias{scat}
\title{Scatterplot}
\usage{
scat(data, x, y, group = NULL, marg = "none", line = "none", se = FALSE)
}
\arguments{
\item{data}{the data as a data frame}

\item{x}{a string naming the variable from \code{data} that contains the  x
coordinates of the points in the plot, variable must be numeric}

\item{y}{a string naming the variable from \code{data} that contains the  y
coordinates of the points in the plot, variable must be numeric}

\item{group}{a string naming the variable from \code{data} that represents
the  grouping variable}

\item{marg}{\code{none} (default), \code{dens}, or \code{box}, provide
respectively no plots, density plots, or box plots on the axes}

\item{line}{\code{none} (default), \code{linear}, or \code{smooth}, provide
respectively no regression line,  a linear regression line, or a smoothed
regression line}

\item{se}{\code{TRUE} or \code{FALSE} (default), show the standard error
for the regression line}
}
\value{
A results object containing:
\tabular{llllll}{
  \code{results$scat} \tab \tab \tab \tab \tab a scatter plot \cr
}
}
\description{
Function for making clean, good looking scatter plots with the option to 
add marginal denisty or box plots.
}
\examples{
set.seed(1337)

X <- rnorm(100)
Y <- 0.5*X + rnorm(100)
dat <- data.frame(X = X, Y = Y)

scat(dat, x = 'X', y = 'Y', line = 'linear', se = TRUE, marg = 'dens')

}
