% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bursts.R
\name{bursts.subconductance_as}
\alias{bursts.subconductance_as}
\title{Imposes a fixed conductance level (0 or 1) to all dwells with subconductance levels to each segment in a burst}
\usage{
bursts.subconductance_as(bursts, level)
}
\arguments{
\item{bursts}{the list of segments}

\item{level}{either 'open' or 'closed'}
}
\value{
A modified copy of the original burst
}
\description{
The user specifies the desired level ('open' or 'closed'). The function applies
segment.subconductance_as to each segment in the burst.
(See segment.subconductance_as for details.)
}
\examples{

infile <- system.file("extdata", "example4.dwt", package = "scbursts")
dwells <- dwt.read(infile)
dwells_c <- risetime.correct_gaussian(Tr=35.0052278, dwells, units="us")
bursts <- bursts.defined_by_tcrit(dwells_c, 100, units="ms")

bursts_d <- bursts.subconductance_as(bursts, "open")

}
