% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hst.R
\name{hst.read}
\alias{hst.read}
\title{Read a MIL ".hst" file to a table.}
\usage{
hst.read(filename, extract = "open", raw = FALSE)
}
\arguments{
\item{filename}{The filename}

\item{extract}{Extract either "open" or "closed" histogram}

\item{raw}{Data is given as log10(milliseconds)-Sqrt(Freq). Setting raw=FALSE yields output as Seconds-Frequency}
}
\value{
A tables with columns "bin", "freq" and "fit".
}
\description{
Read a MIL ".hst" file to a table. By default these files are in log10(Milliseconds)-sqrt(Freq), but unless "raw" is set to TRUE, this function returns a table containing Seconds-Freq
}
\examples{

# import some of the data included with the package
infile <- system.file("extdata", "example1_hst.hst", package = "scbursts")
open_hst   <- hst.read(infile, extract="open")
closed_hst <- hst.read(infile, extract="closed")

head(open_hst)
head(closed_hst)

}
