% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/segment.R
\name{segment.dwells_by_conductance_range}
\alias{segment.dwells_by_conductance_range}
\title{Extract dwells in conductance range. lower <= x <= upper}
\usage{
segment.dwells_by_conductance_range(segment, lower = 0, upper = Inf)
}
\arguments{
\item{segment}{the segment object}

\item{lower}{lower bound on conductance (defaults to 0)}

\item{upper}{upper bound on conductance (defaults to infinity)}
}
\value{
the dwells in a given range
}
\description{
Extract dwells in conductance range. lower <= x <= upper
}
\examples{

# It's more likely that you created states or dwells with some function
states  <-  c(0,    0.2,    0,    1,    0,  0.5,    0,  0.7,    0,    1)
dwells  <-  c(0.1,  1.1,  0.5,  0.2,  1.0,  1.1,  0.6,  1.1,  0.8,  1.1)
my_burst <- segment.create(states, dwells, seg=1, start_time=3.14159, name="example_segment")

half_open <- segment.dwells_by_conductance_range(my_burst, lower=0.2, upper=0.7)
head(half_open)

}
