% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scpi-package.R
\docType{package}
\name{scpi-package}
\alias{scpi-package}
\title{\code{scpi}: A Package to Compute Synthetic Control Prediction Intervals With Multiple Treated Units and Staggered Adoption}
\description{
The package implements estimation, inference procedures, and produces plots for Synthetic Control (SC) methods
using least squares, lasso, ridge, or simplex-type
constraints. Uncertainty is quantified using prediction intervals according to
\insertCite{cattaneo2021methodological-JASA;textual}{scpi} and \insertCite{cattaneo2025methodological-RESTAT;textual}{scpi}.

Included functions are: \link{scdata} and \link{scdataMulti} for data preparation, \link{scest} for point estimation,
\link{scpi} for inference procedures, and \link{scplot} and \link{scplotMulti} for plots.

\code{print()} and \code{summary()} methods are available for \code{\link{scest}} and \code{\link{scpi}}.

Companion \href{https://www.stata.com/}{Stata} and \href{https://www.python.org/}{Python} packages are described in
\insertCite{cattaneo2025software-JSS;textual}{scpi}.

Related Stata, R, and Python packages useful for inference in SC designs are described in the following website:

\href{ https://nppackages.github.io/scpi/}{ https://nppackages.github.io/scpi/}

For an introduction to synthetic control methods, see \insertCite{abadie2021UsingSyntheticControls;textual}{scpi} and references therein.
}
\references{
\insertAllCited{}
}
\seealso{
Useful links:
\itemize{
  \item \url{https://nppackages.github.io/scpi/}
}

}
\author{
Matias Cattaneo, Princeton University. \email{cattaneo@princeton.edu}.

Yingjie Feng, Tsinghua University. \email{fengyj@sem.tsinghua.edu.cn}.

Filippo Palomba, Princeton University (maintainer). \email{fpalomba@princeton.edu}.

Rocio Titiunik, Princeton University. \email{titiunik@princeton.edu}.
}
