% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mle.R
\name{approxMleWn2D}
\alias{approxMleWn2D}
\title{Approximate MLE of the WN diffusion in 2D}
\usage{
approxMleWn2D(data, delta, start, alpha = rep(NA, 3), mu = rep(NA, 2),
  sigma = rep(NA, 2), rho = NA, lower = c(0.01, 0.01, -25, -pi, -pi,
  0.01, 0.01, -0.99), upper = c(rep(25, 3), pi, pi, 25, 25, 0.99),
  maxK = 2, ...)
}
\arguments{
\item{data}{a matrix of dimension \code{c(n, p)}.}

\item{delta}{discretization step.}

\item{start}{starting values, a matrix with \code{p} columns, with each
entry representing a different starting value.}

\item{alpha, mu, sigma, rho}{if their values are provided, the likelihood
function is optimized with respect to the rest of unspecified parameters.
The number of elements in \code{start}, \code{lower} and \code{upper} has to
be modified accordingly (see examples).}

\item{lower, upper}{bound for box constraints as in method \code{"L-BFGS-B"}
of \code{\link[stats]{optim}}.}

\item{maxK}{maximum absolute winding number used if \code{circular = TRUE}.}

\item{...}{further parameters passed to \code{\link{mleOptimWrapper}}.}
}
\value{
Output from \code{\link{mleOptimWrapper}}.
}
\description{
Approximate Maximum Likelihood Estimation (MLE) for the Wrapped
Normal (WN) in 2D using the wrapped Ornstein--Uhlenbeck diffusion.
}
\details{
See Section 3.3 in García-Portugués et al. (2019) for details.
}
\examples{
alpha <- c(2, 2, -0.5)
mu <- c(0, 0)
sigma <- c(1, 1)
rho <- 0.2
samp <- rTrajWn2D(x0 = c(0, 0), alpha = alpha, mu = mu, sigma = sigma,
                  rho = rho, N = 1000, delta = 0.1)
approxMleWn2D(data = samp, delta = 0.1, start = c(alpha, mu, sigma, rho))
approxMleWn2D(data = samp, delta = 0.1, alpha = alpha,
              start = c(mu, sigma), lower = c(-pi, -pi, 0.01, 0.01),
              upper = c(pi, pi, 25, 25))
mleMou(data = samp, delta = 0.1, start = c(alpha, mu, sigma),
       optMethod = "Nelder-Mead")
}
\references{
García-Portugués, E., Sørensen, M., Mardia, K. V. and Hamelryck, T. (2019)
Langevin diffusions on the torus: estimation and applications.
\emph{Statistics and Computing}, 29(2):1--22. \doi{10.1007/s11222-017-9790-2}
}
