% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/artificial_bell_response.R
\encoding{utf-8}
\name{artificialBellResponse}
\alias{artificialBellResponse}
\title{artificialBellResponse}
\usage{
artificialBellResponse(env.stack, config, stack = FALSE,
  compose = "product", rescale = TRUE)
}
\arguments{
\item{env.stack}{a \code{rasterStack} object that contain the environment variable}

\item{config}{config is a \code{list} or \code{matrix} or \code{data.frame} that contain config info, details see details part}

\item{stack}{stack is an option that if you want not compose them togethor (result return as a \code{rasterStack}). Default is FALSE}

\item{compose}{the method compose the suitability together. Default is product}

\item{rescale}{if \code{TRUE} each environment will rescale before compose together}
}
\value{
\code{rasterLayer} or \code{rasterStack} if stack is set to TRUE
}
\description{
artificial bell response method
}
\details{
This method mainly implement artificial bell response method, more detail see references.
}
\examples{
# load the sdmvspecies library
library("sdmvspecies")
library("raster")
# find package's location
package.dir <- system.file(package="sdmvspecies")
# let see where is our sdmvspecies is installed in
package.dir
# find env dir under the package's location
env.dir <- paste(package.dir, "/external/env/", sep="")
# let see env dir
env.dir
# get the environment raster file
file.name <- files <- c("bio1.bil", "bio12.bil", "bio7.bil", "bio5.bil")
files <- paste(env.dir, file.name, sep="")
# make raster stack
env.stack <- stack(files)
# config
config <- list(c("bio1",150, 50), c("bio12", 2000, 500), c("bio7", 400, 100), c("bio5", 300, 100))
# run pick mean
species.raster <- artificialBellResponse(env.stack, config)
# plot map
plot(species.raster)
# species distribution map
species.distribution.raster <- species.raster > 0.2
# plot map
plot(species.distribution.raster)
}
\references{
Varela, S., Anderson, R. P., García-Valdés, R., & Fernández-González, F. (2014). Environmental filters reduce the effects of sampling bias and improve predictions of ecological niche models. Ecography.
}

