% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pipe.R
\name{\%.>\%}
\alias{\%.>\%}
\title{Explicit Dot Pipe}
\usage{
lhs \%.>\% rhs
}
\arguments{
\item{lhs}{A value to be piped forward.}

\item{rhs}{A function call that utilizes the dot (\code{.}) placeholder to specify
where \code{lhs} should be placed.}
}
\value{
No Return Value.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

This operator pipes an object forward into a function or call expression
using an explicit placement of the dot (\code{.}) placeholder. Unlike magrittr's
\link[magrittr:pipe]{\%>\%} operator, \verb{\%.>\%} does not automatically place the
left-hand side (\code{lhs}) as the first argument in the right-hand side (\code{rhs})
call. This operator provides a simpler alternative to the use of braces with
magrittr, while achieving similar behavior.
}
\details{
The \verb{\%.>\%} operator is used to pipe the \code{lhs} value into the \code{rhs} function
call. Within the \code{rhs} expression, the placeholder \code{.} represents the
position where \code{lhs} will be inserted. This provides more control over where
the \code{lhs} value appears in the \code{rhs} function call, compared to the magrittr
pipe operator which always places \code{lhs} as the first argument of \code{rhs}.

Unlike magrittr's pipe, which may require the use of braces to fully control
the placement of \code{lhs} in nested function calls, \verb{\%.>\%} simplifies this by
directly allowing multiple usages of the dot placeholder without requiring
braces. For example, the following expression using magrittr's pipe and
braces:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{library(magrittr)

1:10 \%>\% \{ c(min(.), max(.)) \}
}\if{html}{\out{</div>}}

can be written as:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{1:10 \%.>\% c(min(.), max(.))
}\if{html}{\out{</div>}}

without needing additional braces.
\subsection{Downside}{

The disadvantage of \verb{\%.>\%} is that you always need to use
the dot placeholder, even when piping to the first argument of the
right-hand side (\code{rhs}).
}
}
\examples{

# Equivalent to `subset(head(iris), 1:nrow(head(iris)) \%\% 2 == 0)`
head(iris) \%.>\% subset(., 1:nrow(.) \%\% 2 == 0)

# Equivalent to `c(min(1:10), max(1:10))`
1:10 \%.>\% c(min(.), max(.))

}
