% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parse_dttm_fmt.R
\name{find_int_gap}
\alias{find_int_gap}
\title{Find gap intervals in integer sequences}
\usage{
find_int_gap(x, xmin = min(x), xmax = max(x))
}
\arguments{
\item{x}{An integer vector.}

\item{xmin}{Left endpoint integer value.}

\item{xmax}{Right endpoint integer value.}
}
\value{
A \link[tibble:tibble-package]{tibble} of gap intervals of two columns:
\itemize{
\item \code{start}: left endpoint
\item \code{end}: right endpoint
If no gap intervals are found then an empty \link[tibble:tibble-package]{tibble}
is returned.
}
}
\description{
\code{\link[=find_int_gap]{find_int_gap()}} determines the \code{start} and \code{end} positions for gap intervals
in a sequence of integers. By default, the interval range to look for gaps is
defined by the minimum and maximum values of \code{x}; specify \code{xmin} and \code{xmax}
to change the range explicitly.
}
\keyword{internal}
