% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization-functions.R
\name{plot_overview}
\alias{plot_overview}
\title{Visualization Functions for Search Strategy Analysis}
\usage{
plot_overview(metrics)
}
\arguments{
\item{metrics}{List of calculated metrics from SearchAnalyzer}
}
\value{
ggplot object showing key performance indicators
}
\description{
This file contains all visualization functions used by the SearchAnalyzer class
and other components of the searchAnalyzeR package.
Create Overview Performance Plot
}
\details{
Creates a focused overview plot displaying the core search performance metrics:
\itemize{
\item Precision: Proportion of retrieved articles that are relevant
\item Recall: Proportion of relevant articles that were retrieved
\item F1 Score: Harmonic mean of precision and recall
}
The plot uses color coding to distinguish between metric types and
displays exact values on top of each bar.
}
\examples{
# Assume you have calculated metrics
metrics <- list(
  precision_recall = list(precision = 0.8, recall = 0.6, f1_score = 0.69)
)

overview_plot <- plot_overview(metrics)
print(overview_plot)
}
\seealso{
\code{\link{plot_pr_curve}}, \code{\link{plot_temporal}}
}
