% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/secrets.R
\name{share_secret}
\alias{share_secret}
\title{Share a secret among some users.}
\usage{
share_secret(name, users, key = local_key(), vault = NULL)
}
\arguments{
\item{name}{Name of the secret, a string that can contain alphanumeric
characters, underscores, dashes and dots.}

\item{users}{addresses of users that will have access to the secret.
(See \code{\link[=add_user]{add_user()}}).}

\item{key}{Private key that has access to the secret. (I.e. its
corresponding public key is among the vault users.)}

\item{vault}{Vault location (starting point to find the vault).
To create a vault, use \code{\link[=create_vault]{create_vault()}} or \code{\link[=create_package_vault]{create_package_vault()}}.
If this is \code{NULL}, then \code{secret} tries to find the vault automatically:
\itemize{
\item If the \code{secret.vault} option is set to path, that is used as the
starting point.
\item Otherwise, if the \code{R_SECRET_VAULT} environment variable is set to a
path, that is used as a starting point.
\item Otherwise the current working directory is used as the starting
point.
}

If the starting point is a vault, that is used. Otherwise, if the
starting point is in a package tree, the \code{inst/vault} folder is used
within the package. If no vault can be found, an error is thrown.}
}
\description{
Use this function to extend the set of users that have access to a
secret. The calling user must have access to the secret as well.
}
\seealso{
\code{\link[=unshare_secret]{unshare_secret()}}, \code{\link[=list_owners]{list_owners()}} to list users that have
access to a secret.

Other secret functions: 
\code{\link{add_secret}()},
\code{\link{delete_secret}()},
\code{\link{get_secret}()},
\code{\link{list_owners}()},
\code{\link{list_secrets}()},
\code{\link{local_key}()},
\code{\link{unshare_secret}()},
\code{\link{update_secret}()}
}
\concept{secret functions}
