% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bayes_eval.R
\name{compute_mcmc_results}
\alias{compute_mcmc_results}
\title{Results for sampled parameters and states}
\usage{
compute_mcmc_results(
  model,
  settings,
  mcmc,
  data,
  HPDIprob = NULL,
  fit = NULL,
  ...
)
}
\arguments{
\item{model}{state space model object, returned by the function
\code{define_ssmodel}}

\item{settings}{list with model setting, in the format returned by the
function \code{initialize_settings}}

\item{mcmc}{list with draws of parameters and states (including burnin phase)}

\item{data}{list with at least two named components: \code{tsm} is a multiple
time series object that contains all observation series, \code{weights}
is a named list of time series with (nominal) weights, the list names
correspond to the different groups, i.e., \code{group1, group2, subgroup1},
if present in the model}

\item{HPDIprob}{probability of highest posterior density interval, optional
if \code{fit} is supplied}

\item{fit}{(optional) an object of class \code{fit} (returned by the function
\code{estimate_ssmodel} and this function).}

\item{...}{additional arguments (in case \code{fit} is supplied)}
}
\value{
An object of class \code{ss_fit}.
}
\description{
Computes estimation results for the MCMC sampling output for a
specific HPDI and evaluation function (e.g. mean or median).
}
\details{
If \code{fit} is supplied, the arguments
\code{model, settings, mcmc} will be taken from this object.
}
