% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{plot.ss_fit}
\alias{plot.ss_fit}
\title{Plots of results}
\usage{
\method{plot}{ss_fit}(
  x,
  plot_type = "timeseries",
  estimate = "median",
  data = data,
  n_col = 3,
  n_sep = 5,
  file_path = NULL,
  title = TRUE,
  save = FALSE,
  device = "jpg",
  width = 10,
  height = 3,
  units = "in",
  highlighted_area = NULL,
  plot_start = NULL,
  plot_end = NULL,
  alpha = 0.05,
  include_burnin = FALSE,
  ...
)
}
\arguments{
\item{x}{object of class \code{ss_fit}}

\item{plot_type}{type of plots, options are
\code{"timeseries", "density", "trace"}}

\item{estimate}{character specifying the posterior estimate. Valid options
are \code{"mean"} and \code{"median"}, the default is
\code{estimate = "median"}.}

\item{data}{list with at least two named components: \code{tsm} is a multiple
time series object that contains all observation series, \code{weights}
is a named list of time series with (nominal) weights, the list names
correspond to the different groups, i.e., \code{group1, group2, subgroup1},
if present in the model}

\item{n_col}{number of columns for grid plots}

\item{n_sep}{increments of x axis ticks in years}

\item{file_path}{file path for plots}

\item{title}{boolean indicating if plots should contain titles}

\item{save}{boolean indicating if plots should be saved, if \code{FALSE}, the
plots will be printed instead, default is \code{save = FALSE} (ignored if
\code{file_path} is provided)}

\item{device}{character string with format used in \code{ggsave}}

\item{width}{plot width in \code{units}, for grid plots adjusted for the
number of plot columns \code{n_col}}

\item{height}{plot height in \code{units}, for grid plots adjusted for the
number of plot rows implied by \code{n_col}}

\item{units}{units for plot size (\code{"in", "cm", "mm", or "px"})}

\item{highlighted_area}{data frame with two columns called \code{start} and
\code{end} containing start and end date, e.g. \code{1990.25} and
\code{1992.75} for 1990 Q2 until 1992 Q4
(only used if \code{plot_type = "timeseries"})}

\item{plot_start}{start of x axis in years, e.g., \code{1990.5} (only used if
\code{plot_type = "timeseries"})}

\item{plot_end}{end of x axis in years, e.g., \code{2010.25} (only used if
\code{plot_type = "timeseries"})}

\item{alpha}{cut off value for posterior (only used if
\code{plot_type = "density"})}

\item{include_burnin}{logical indicating if burnin phase should be included
(only used if \code{plot_type = "trace"})}

\item{...}{ignored}
}
\value{
nothing
}
\description{
Creates a set of time series, density, or trace plots.
}
