% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ss_model.R
\name{update_nonlinear_constraints}
\alias{update_nonlinear_constraints}
\title{Non linear constraints update}
\usage{
update_nonlinear_constraints(state, model, settings, df_constr, data)
}
\arguments{
\item{state}{multiple time series object with states}

\item{model}{state space model object (with assigned parameters)}

\item{settings}{list with model setting, in the format returned by the
function \code{initialize_settings}}

\item{df_constr}{data frame with constraint settings}

\item{data}{list with at least two named components: \code{tsm} is a multiple
time series object that contains all observation series, \code{weights}
is a named list of time series with (nominal) weights, the list names
correspond to the different groups, i.e., \code{group1, group2, subgroup1},
if present in the model}
}
\value{
The state space model object \code{model} with updates matrices.
}
\description{
Updates the system matrices of a state space model to include
non linear constraints.
}
\details{
\code{data} is preferably the output of funtion \code{prepare_data}.
}
\examples{
data("data_ch")
settings <- initialize_settings()
data <- prepate_data(
  settings = settings,
  tsl = data_ch$tsl,
  tsl_n = data_ch$tsl_n
)
model <- define_ssmodel(
  settings = settings, 
  data = data
)
}
\keyword{internal}
