% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ss_model.R
\name{update_ssmodel}
\alias{update_ssmodel}
\title{State space model update}
\usage{
update_ssmodel(pars, model, model_last, settings, df_set)
}
\arguments{
\item{pars}{named vector with all parameters}

\item{model}{state space model object (unassigned)}

\item{model_last}{state space model object (previous draw)}

\item{settings}{list with model setting, in the format returned by the
function \code{initialize_settings}}

\item{df_set}{data frame with model settings}
}
\value{
The state space model object \code{model} with updates matrices.
}
\description{
Updates the system matrices of a state space model.
}
\details{
\code{data} is preferably the output of funtion \code{prepare_data}.
}
\examples{
data("data_ch")
settings <- initialize_settings()
data <- prepate_data(
  settings = settings,
  tsl = data_ch$tsl,
  tsl_n = data_ch$tsl_n
)
model <- define_ssmodel(
  settings = settings, 
  data = data
)
}
\keyword{internal}
