% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/huidobro.R
\name{huidobro}
\alias{huidobro}
\title{Fits Garcia-Huidobro's thermal time model}
\usage{
huidobro(d, min.ptos = 3, tops = c("Max R2","Max value"), fractions =
  (1:9)/10)
}
\arguments{
\item{d}{a data.table within a "physiodata" object, containing the cumulative
germination proportion at each scoring time and temperature treatment.}

\item{min.ptos}{minimal number of data points (i.e. different temperature
treatments) needed to fit the suboptimal and supraoptimal germination
models. If the number of points available in the dataset is less than
\code{min.ptos}, then the suboptimal or the supraoptimal models are not
fitted.}

\item{tops}{method used to divide the dataset in suboptimal and supraoptimal
sections. "Max value" splits the data by the temperature that produces the
highest seed germination rate. "Max R2" splits the data by the temperature
that maximises the R2 of the suboptimal and supraoptimal linear
regressions.}

\item{fractions}{percentiles into which the seed population is split to fit
the thermal time model. The default is the 9 deciles (i.e. t10, t20.. t90)
as used by Garcia-Huidobro.}
}
\value{
\code{huidobro} returns a S3 object of class "huidobro" with the
  results of fitting the thermal time model. The generic functions
  \code{summary} and \code{plot} are used to obtain and visualize the model
  results.
}
\description{
\code{huidobro} fits a thermal time seed germination model using the method
of Garcia-Huidobro (Garcia-Huidobro et al. 1982, Gummerson 1986, Bewley et
al. 2013). This function can be used only with one-group dataset, i.e. one
seed lot of one species. To fit models to grouped datasets (multi-seedlots,
multi-species) use the function \code{physiotime} instead.
}
\examples{
# format dataset with physiodata
malva <- physiodata(subset(centaury, population == "La Malva"), x = "temperature")
# huidobro() uses the $proportions element within the physiodata object
h <- huidobro(malva$proportions)
h # prints the main thermal time variables
summary(h) # returns the main thermal time variables as a data.table
plot(h) # plots the fitted model
}
\references{
Bewley, J. D., Bradford, K. J., Hilhorst, H. W., & Nonogaki, H.
  (2013). Thermal Time Models. In Seeds: Physiology of Development,
  Germination and Dormancy, 3rd Edition (pp. 312-317). Springer, New York,
  NY. Bradford, K. J. (1990). A water relations analysis of seed germination
  rates. Plant Physiology, 94(2), 840-849.

  Garcia-Huidobro, J., Monteith, J. L., & Squire, G. R. (1982). Time,
  temperature and germination of pearl millet (Pennisetum typhoides S. & H.)
  I. Constant temperature. Journal of Experimental Botany, 33(2), 288-296.

  Gummerson, R. J. (1986). The effect of constant temperatures and osmotic
  potentials on the germination of sugar beet. Journal of Experimental
  Botany, 37(6), 729-741.
}
