% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fforms_combination.R
\name{fforms_combinationforecast}
\alias{fforms_combinationforecast}
\title{Combination forecast based on fforms}
\usage{
fforms_combinationforecast(
  fforms.ensemble,
  tslist,
  database,
  h,
  holdout = TRUE,
  parallel = FALSE,
  multiprocess = future::multisession
)
}
\arguments{
\item{fforms.ensemble}{a list output from fforms_ensemble function}

\item{tslist}{list of new time series}

\item{database}{whethe the time series is from mcom or other}

\item{h}{length of the forecast horizon}

\item{holdout}{if holdout=TRUE take a holdout sample from your data to caldulate forecast accuracy measure, if FALSE all of the data will be used for forecasting. Default is TRUE}

\item{parallel}{If TRUE, multiple cores (or multiple sessions) will be used. This only speeds things up
when there are a large number of time series.}

\item{multiprocess}{The function from the \code{future} package to use for parallel processing. Either
\code{\link[future]{multisession}} or \code{\link[future]{multicore}}. The latter is preferred for Linux and MacOS.}
}
\value{
a list containing, point forecast, confidence interval, accuracy measure
}
\description{
Compute combination forecast based on the vote matrix probabilities
}
\author{
Thiyanga Talagala
}
