% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cluster.R
\name{colorClusters}
\alias{colorClusters}
\title{Assign colors to clusters.}
\usage{
colorClusters(cset, colf, ...)
}
\arguments{
\item{cset}{a clustering set as returned by \code{\link{clusterTimeseries}}}

\item{colf}{a function that generates \code{n} colors}

\item{...}{arguments to color function \code{colf}}
}
\value{
Returns the input "clustering" object with a list of vectors
("colors"), each providing a named vector of colors for each cluster.
}
\description{
Takes a clustering set as returned by \code{\link{clusterTimeseries}} and
assigns colors to each cluster in each clustering along
the "hue" color wheel, as in \code{scale_colour_hue} in \code{ggplot2}.
If \code{cset} contains a sorting, this sorting will be used to assign
colors along the color wheel, otherwise a sorting will be calculated first,
using \code{\link{sortClusters}}.
}
