% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sFLB.R
\name{sFLB}
\alias{sFLB}
\title{'Shared' full-likelihood Bayes factor}
\usage{
sFLB(
  x,
  carriers = NULL,
  noncarriers = NULL,
  affected = NULL,
  unknown = NULL,
  penetrances = NULL,
  liability = NULL,
  ...
)
}
\arguments{
\item{x}{A \code{\link[pedtools:ped]{pedtools::ped()}} object.}

\item{carriers}{A character vector (or coercible to such), containing the ID
labels of pedigree members known to carry one copy of the variant in
question.}

\item{noncarriers}{A character vector (or coercible to such), containing the
ID labels of pedigree members known \emph{not} to carry the variant in question.}

\item{affected}{The affected pedigree members.}

\item{unknown}{Pedigree members with unknown affection status.}

\item{penetrances}{A numeric vector of length 3 \verb{(f0, f1, f2)}, or a
matrix-like with 3 columns, where row \code{i} contains the penetrances of
liability class \code{i}.}

\item{liability}{A vector of length \code{pedsize(x)}, containing for each
pedigree member the row number of \code{penetrances} which should be used for
that individual. If unnamed, it is assumed that the individuals are taken
in order. (If \code{penetrances} is just a vector, it will be used for all
classes.) If \code{liability} is NULL (the default), it is set to \code{1} for all
individuals.}

\item{...}{Further parameters.}
}
\value{
A positive number, the sFLB score.
}
\description{
Computes the shared Bayes factor for co-segregation, assuming autosomal
dominant inheritance and a single introduction of the variant.
}
\examples{

### Case 1

x = halfSibPed(nch1 = 2, type = "maternal")

sFLB(x, unknown = 1:3, affected = 4:6, carriers = 4:6,
     noncarriers = NULL, penetrances = c(0.1, 0.5, 0.5))


### Ratajska et al. (2023), Family B

y = nuclearPed(5, sex = c(2,1,1,1,1)) |>
      addDaughter(parents = 3, verbose = FALSE) |>
      relabel("asPlot")

sFLB(y, unknown = NULL, affected = c(1,4,5,8), carriers = c(1,4,8),
     noncarriers = 6:7, penetrances = c(0.01, 0.9, 0.9))

}
\references{
Ratajska A, Vigeland MD, Wirgenes KV, \emph{et al}. \emph{The use of
segregation analysis in interpretation of sequence variants in SMAD3: A
case report.} Mol Genet Genomic Med, 2023. \doi{10.1002/mgg3.2107}.
}
