% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/actions.R
\name{elem_click}
\alias{elem_click}
\alias{elem_double_click}
\alias{elem_right_click}
\title{Click an element}
\usage{
elem_click(x, js = FALSE, timeout = NULL)

elem_double_click(x, js = FALSE, timeout = NULL)

elem_right_click(x, js = FALSE, timeout = NULL)
}
\arguments{
\item{x}{A \code{selenider_element} object.}

\item{js}{Whether to click the element using JavaScript.}

\item{timeout}{How long to wait for the element to exist.}
}
\value{
\code{x}, invisibly.
}
\description{
Clicks on an HTML element, either by simulating a mouse click or by
triggering the element's "click" event.

\code{elem_click()} left clicks on the element, \code{elem_double_click()} left clicks
on the element two times in a short period of time, while
\code{elem_right_click()} right clicks on an element, opening its context menu.
}
\examples{
\dontshow{if (selenider::selenider_available(online = FALSE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
html <- "
<button onclick = hidetext() oncontextmenu = showtext()></button>
<p id = 'texttohide'>Hello!</p>
"

js <- "
function hidetext() {
  document.getElementById('texttohide').style.display = 'none'
}

function showtext() {
  document.getElementById('texttohide').style.display = 'block'
}
"

session <- minimal_selenider_session(html, js = js)

elem_expect(s("p"), is_visible)

s("button") |>
  elem_click()

elem_expect(s("p"), is_invisible)

s("button") |>
  elem_right_click()

elem_expect(s("p"), is_visible)
\dontshow{\}) # examplesIf}
}
\seealso{
Other actions: 
\code{\link{elem_hover}()},
\code{\link{elem_scroll_to}()},
\code{\link{elem_select}()},
\code{\link{elem_set_value}()},
\code{\link{elem_submit}()}
}
\concept{actions}
