\name{extractProbs}
\alias{extractProbs}

\title{Extracts conditional genotype probabilities}

\description{This function extracts the symbolic formulas for the
conditional genotype probabilities from the uppermost level of the
(sub)tree.}

\usage{
extractProbs(F)
}
\arguments{

  \item{F}{A sub-tree in the format generated by function
  \code{genSubtree.2M} or \code{genSubtree.3M}.}

}

\value{A character vector with the symbolic formulas. For three-marker
 genotypes, symbol \code{x} is the recombination frequency between
 markers 1 and 2 and \code{y} that between markers 2 and 3. For
 two-marker genotypes, symbol \code{z} is the recombination frequency
 between markers 1 and 2.  The names of the elements indicate the
 allelic configuration of the two gametes comprising the genotype as
 \code{gamete1-gamete2} (e.g., \code{"AAB-AAA"}). The elements sum to
 1.}

\author{
Frank Technow
}

\examples{

probs.2M <- extractProbs(genSubtree.2M("BA","AA"))
probs.3M <- extractProbs(genSubtree.3M("BAA","AAB"))

## must sum to 1
stopifnot(all.equal(evalProb(probs.2M, z = 0.044),1))
stopifnot(all.equal(evalProb(probs.3M, x = 0.123, y = 0.344),1))

}

