% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/increment_version.R
\name{increment_version}
\alias{increment_version}
\alias{increment_version.svlist}
\alias{increment_version.svptr}
\title{Increment version field}
\usage{
increment_version(x, field, value, ...)

\method{increment_version}{svptr}(x, field = c("major", "minor", "patch"),
  value, ...)

\method{increment_version}{svlist}(x, field, value, ...)
}
\arguments{
\item{x}{An object of class "svlist" or "svptr".}

\item{field}{For the "svptr" class a character string detailing the field to
set (major, minor etc...). For the "svlist" class a character vector
detailing the field to set for each list member.}

\item{value}{The value to increment the field by. For fields "major", "minor"
and "patch" this is an integer. For the "svptr" class value is a scalar. For
the "svlist" class value is an integer vector detailing the value to increment by for
each list member.}

\item{...}{Additional arguments passed on to methods.}
}
\value{
returns an object of class svptr or svlist
}
\description{
Increment the version field. "Major", "minor" and "patch" fields are set as
    integers.
    Fields of lower precedence are reset to default value (0L)
}
\examples{
semver <- parse_version(c("1.2.3", "1.2.4-alpha+bld1"))
increment_version(semver[[2]], "major", 1L)
increment_version(semver[[2]], "major", -1L)
increment_version(semver, c("minor", "patch"), c(3L, 9L))
increment_version(semver, c("minor", "patch"), c(-1L, -3L))
increment_version(semver, c("minor"), 1L)
}

