% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/populateDBFunctions.R
\name{dbDeleteStudies}
\alias{dbDeleteStudies}
\title{Delete one or more studies in SEND database}
\usage{
dbDeleteStudies(dbToken, studyIdList)
}
\arguments{
\item{dbToken}{Mandatory\cr
Token for the open database connection (see \code{\link{initEnvironment}}).}

\item{studyIdList}{Mandatory, character\cr
A list or vector of study id values}
}
\value{
No return value, called for side effects\cr
}
\description{
Deletes data from all domains for one or more studies in an SQLite based SEND
database
}
\details{
The database must be a SQLite database - no other types of databases are
supported by this function.
}
\examples{
\dontrun{
# delete one study
dbDeleteStudies(myDbToken, '122312')
# delete multiple studies
dbDeleteStudies(myDbToken, list('122312', '552343', '0942347'))
}
}
