% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getSubjSpeciesStrain.R
\name{getSubjSpeciesStrain}
\alias{getSubjSpeciesStrain}
\title{Extract the set of animals of the specified species and strain - or just add
the species and strain for each animal.}
\usage{
getSubjSpeciesStrain(
  dbToken,
  animalList,
  speciesFilter = NULL,
  strainFilter = NULL,
  inclUncertain = FALSE,
  exclusively = FALSE,
  noFilterReportUncertain = TRUE
)
}
\arguments{
\item{dbToken}{Mandatory\cr
Token for the open database connection (see \code{\link{initEnvironment}}).}

\item{animalList}{Mandatory, data.table.\cr
A table with the list of animals to process.\cr
The table must include at least columns named 'STUDYID' and 'USUBJID'.}

\item{speciesFilter}{Optional, character.\cr
The species value(s) to use as criterion for filtering of the input data
table.\cr
It can be a single string, a vector or a list of multiple strings.}

\item{strainFilter}{Optional, character.\cr
The strain value(s) to use as criterion for filtering of the input data
table.\cr
It is only valid to specify value(s) if one or more values have been
specified for parameter \code{speciesFilter}\cr
It can be a single string, a vector or a list of multiple strings.
When multiple values are specified for \code{speciesFilter}, each strain
value must be prefixed by species and ':' , e.g.
\code{c('RAT:WISTAR','DOG: BEAGLE')}.\cr
There may be included any number of blanks after ':'}

\item{inclUncertain}{Mandatory, boolean.\cr
Indicates whether animals for which the species or strain cannot be
confidently identified shall be included or not in the output data table.}

\item{exclusively}{Mandatory, boolean.
\itemize{
\item TRUE: Include animals only for studies with no other species and
optional strains then included in \code{speciesFilter} and
\code{strainFilter}
\item FALSE: Include animals for all studies with species and strain
matching \code{speciesFilter} and \code{strainFilter} respectively.
}}

\item{noFilterReportUncertain}{Optional, boolean.\cr
Only relevant if the \code{speciesFilter} and  \code{strainFilter} are
empty.\cr
Indicates if the reason should be included if the species or strain cannot
be confidently decided for an animal.}
}
\value{
The function returns a data.table with columns:
\itemize{
\item STUDYID       (character)
\item Additional columns contained in the \code{animalList} table
\item SPECIES       (character)
The value is always returned in uppercase and trimmed for leading/trailing
blanks.
\item STRAIN        (character)
The value is always returned in uppercase and trimmed for leading/trailing
blanks.
\item UNCERTAIN_MSG (character)\cr
Included when parameter \code{inclUncertain=TRUE}.\cr
In case the species or strain cannot be confidently matched during the
filtering of data, the column contains an indication of the reason.\cr
Is NA for rows where species and strain can be confidently matched.\cr
A non-empty UNCERTAIN_MSG value generated by this function is merged with
non-empty UNCERTAIN_MSG values which may exist in the input set of animals
specified in \code{animalList} - separated by '|'.
\item NOT_VALID_MSG (character)\cr
Included when parameter \code{noFilterReportUncertain=TRUE}.\cr
In case the species or strain cannot be confidently decided, the column
contains an indication of the reason.\cr
Is NA for rows where species and strain can be confidently decided.\cr
A non-empty NOT_VALID_MSG value generated by this function is merged with
non-empty NOT_VALID_MSG values which may exist in the input set of animals
\code{animalList} - separated by '|'.
}
}
\description{
Returns a data table with the set of animals included in the
\code{animalList} matching the species and strain specified in the
\code{speciesFilter} and \code{strainFilter}.\cr
If the \code{speciesFilter} and \code{strainFilter} are empty (null, na or
empty string) - all rows from \code{animalList} are returned with additional
populated SPECIES and STRAIN columns.
}
\details{
The species and strain per animal respectively are identified by a
hierarchical lookup in these domains
\itemize{
\item DM - If the DM.SPECIES (DM.STRAIN) isn't empty, this value is
included in the output.\cr
\item TX - if a TX parameter 'SPECIES' ('STRAIN') exists for the group
related to the animal, the TXVAL value for this is included in the
output.\cr
\item TS - if a TS parameter 'SPECIES' ('STRAIN') exists, this is included
in the output.\cr
}
The comparisons of species/strain values is done case insensitive and trimmed
for leading/trailing blanks.

If input parameter \code{inclUncertain=TRUE}, uncertain animals are included
in the output set. These uncertain situations are identified and reported for
SPECIES and STRAIN respectively (in column UNCERTAIN_MSG):
\itemize{
\item TS parameter SPECIES/STRAIN is missing or invalid (not CT value -
CDISC SEND code list SPECIES/STRAIN) and TX parameter SPECIES/STRAIN is
missing or invalid (not CT value) and DM.SPECIES/STRAIN is missing or
invalid (not CT value)
\item Different values of SPECIES/STRAIN across TS, TX and DM for studies
where no or only one TS parameter SPECIES/STRAIN is registered
\item Multiple TS parameter SPECIES/STRAIN values are registered for study
and TX parameter SPECIES/STRAIN and/or DM.SPECIES/STRAIN do not match any
of the TS values.
\item  Multiple TS parameter SPECIES/STRAIN values are registered for study
and TX parameter SPECIES/STRAIN and DM.SPECIES/STRAIN are unequal.
}
The same checks are performed and reported in column NOT_VALID_MSG if
\code{speciesFilter} and \code{strainFilter} are empty and
\code{noFilterReportUncertain=TRUE}.
}
\examples{
\dontrun{
# Extract rats and mice plus uncertain animals
getSubjSpeciesStrain(dbToken, controlAnimals,
                     speciesFilter = c('RAT', 'MOUSE'),
                     inclUncertain = TRUE)
# Extract Spargue-Dawley rats plus uncertain animals.
# Include only animals from studies which do not contain other species or
# strains
getSubjSpeciesStrain(dbToken, controlAnimals,
                     speciesFilter = 'RAT',
                     strainFilter = 'SPRAGUE-DAWLEY',
                     inclUncertain = TRUE,
                     exclusively = TRUE,
                     noFilterReportUncertain = TRUE)
# Extract Wistar rats and and Beagle dogs - and no uncertain animals
getSubjSpeciesStrain(dbToken, controlAnimals,
                     speciesFilter = c('RAT', 'DOG'),
                     strainFilter = c('RAT: WISTAR', 'DOG: BEAGLE'))
# No filtering, just add SPECIES and STRAIN - do not include messages when
# these values cannot be confidently found
getSubjSpeciesStrain(dbToken, controlAnimals,
                     noFilterReportUncertain = FALSE)
}
}
