% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oscillators.R
\name{oscillator_pattern}
\alias{oscillator_pattern}
\title{Pattern-based oscillator}
\usage{
oscillator_pattern(pattern, freq = 440, duration = 1, rate = 44100)
}
\arguments{
\item{pattern}{Numeric vector, pattern.}

\item{freq}{Numeric, note frequency in Hz}

\item{duration}{Numeric, note duration in second}

\item{rate}{Numeric, sampling rate in Hz}
}
\value{
An object of class 'soundSample'.
}
\description{
Creates a soundSample by repeating a user-provided pattern.
}
\examples{
sam <- oscillator_pattern(pattern=airquality$Ozone,freq=110,duration=0.1)
plot(sam)
\dontrun{
# This line of code is wrapped in \dontrun{} since it relies
# on an external audio player to listen to the audio sample.
# See ?tuneR::setWavPlayer for setting a default player.
listen(sam)}
}
