% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/effects.R
\name{shiftPitch}
\alias{shiftPitch}
\title{Pitch shifter}
\usage{
shiftPitch(sample, n)
}
\arguments{
\item{sample}{Sound sample object.}

\item{n}{numeric, number of semitones.}
}
\value{
A sound sample object.
}
\description{
Shift the pitch of a sound sample by n semitones. Note that the duration of the
resulting sample is not the same as that of the original.
}
\examples{
# Define a A sound sample and get a D by adding 5 semitones
A <- soundSample(sin(2*pi*seq(0,0.5,1/44100)*220)) # 0.5-second A (220 Hz)
D <- shiftPitch(A,5)
}
