% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getBsplineBasis.R
\name{getBsplineBasis}
\alias{getBsplineBasis}
\title{Compute cubic B-spline basis functions for the given wavenumbers.}
\usage{
getBsplineBasis(V, n.b, pen, prec = 1e-08)
}
\arguments{
\item{V}{a \code{vector} of wavenumbers, \eqn{\Delta \tilde{\nu}}.}

\item{n.b}{the number of basis functions to use.}

\item{pen}{the smoothing penalty hyperparameter.}

\item{prec}{a constant scale factor.}
}
\value{
a \code{list} containing:
\describe{
 \item{\code{basis}}{A dense nwl by n.b matrix containing the values of the basis functions.} 
 \item{\code{precision}}{A sparse n.b by n.b \code{dsCMatrix}, the inverse of the prior covariance.}
 \item{\code{distance}}{The distance between each knot \eqn{(cm^{-1})}.}
 \item{\code{knots}}{The knot locations.}
}
}
\description{
This function computes penalised cubic B-splines using the method proposed by
Eilers & Marx (1996). The spline coefficients can be computed efficiently
using sparse matrix algebra, as described in Sect. 2.3.3 of Green & Silverman
(1994) and Appendix B of Ruppert, Wand & Carroll (2003).
}
\references{
Eilers, PHC & Marx, BD (1996) "Flexible smoothing with B-splines and
penalties," Statist. Sci.  11(2): 89--121, \doi{10.1214/ss/1038425655}

Green, PJ & Silverman, BW (1994) "Nonparametric Regression and
Generalized Linear Models: a roughness penalty approach" Chapman & Hall, Boca
Raton, FL, pp. 11--21.

Ruppert, D; Wand, MP & Carroll, RJ (2003) "Semiparametric Regression" CUP,
Cambridge, UK, pp. 336--340.
}
\seealso{
\code{\link[Matrix:sparseMatrix-class]{sparseMatrix}}
}
