% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-member.R
\name{Member}
\alias{Member}
\title{R6 Class representing a project member}
\description{
R6 Class representing a resource for managing project members.
}
\examples{

## ------------------------------------------------
## Method `Member$print`
## ------------------------------------------------

\dontrun{
 # x is API response when member is requested
 member_object <- Member$new(
                    res = x,
                    href = x$href,
                    auth = auth,
                    response = attr(x, "response")
                   )

 # Print member object
 member_object$print()
}


## ------------------------------------------------
## Method `Member$reload`
## ------------------------------------------------

\dontrun{
 # x is API response when member is requested
 member_object <- Member$new(
                    res = x,
                    href = x$href,
                    auth = auth,
                    response = attr(x, "response")
                   )

 # Reload member object
 member_object$reload()
}

}
\section{Super class}{
\code{\link[sevenbridges2:Item]{sevenbridges2::Item}} -> \code{Member}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{id}}{Member's ID.}

\item{\code{username}}{Member's username.}

\item{\code{email}}{Member's email.}

\item{\code{type}}{Member's type.}

\item{\code{permissions}}{Member's permissions.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-Member-new}{\code{Member$new()}}
\item \href{#method-Member-print}{\code{Member$print()}}
\item \href{#method-Member-reload}{\code{Member$reload()}}
\item \href{#method-Member-clone}{\code{Member$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Member-new"></a>}}
\if{latex}{\out{\hypertarget{method-Member-new}{}}}
\subsection{Method \code{new()}}{
Create a new Member object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Member$new(res = NA, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{res}}{Response containing Member object information.}

\item{\code{...}}{Other response arguments.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Member-print"></a>}}
\if{latex}{\out{\hypertarget{method-Member-print}{}}}
\subsection{Method \code{print()}}{
Print method for Member class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Member$print()}\if{html}{\out{</div>}}
}

\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
 # x is API response when member is requested
 member_object <- Member$new(
                    res = x,
                    href = x$href,
                    auth = auth,
                    response = attr(x, "response")
                   )

 # Print member object
 member_object$print()
}

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Member-reload"></a>}}
\if{latex}{\out{\hypertarget{method-Member-reload}{}}}
\subsection{Method \code{reload()}}{
Reload Member object information.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Member$reload()}\if{html}{\out{</div>}}
}

\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
 # x is API response when member is requested
 member_object <- Member$new(
                    res = x,
                    href = x$href,
                    auth = auth,
                    response = attr(x, "response")
                   )

 # Reload member object
 member_object$reload()
}

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Member-clone"></a>}}
\if{latex}{\out{\hypertarget{method-Member-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Member$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
