% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-imports-utils.R
\name{prepare_items_for_bulk_import}
\alias{prepare_items_for_bulk_import}
\title{Prepare items for bulk import}
\usage{
prepare_items_for_bulk_import(
  volume_items,
  destination_project = NULL,
  destination_parent = NULL,
  autorename = FALSE,
  preserve_folder_structure = TRUE
)
}
\arguments{
\item{volume_items}{A list of \code{\link{VolumeFile}} or
\code{\link{VolumePrefix}} objects to be imported.}

\item{destination_project}{Destination project ID or \code{\link{Project}}
object. Not required, but either \cr
\code{destination_project} or
\code{destination_parent} directory must be provided.}

\item{destination_parent}{Folder ID or \code{\link{File}} object
(with \code{type = 'FOLDER'}). Not required, but either \cr
\code{destination_project} or \code{destination_parent} directory must be provided.}

\item{autorename}{Logical indicating whether to autorename conflicting
files (default is \code{FALSE}). Set to \code{TRUE} if you want to automatically
rename the item (by prefixing its name with an underscore and number) if
another one with the same name already exists at the destination.
Bear in mind that if used with folders import, the folder content will
be renamed, not the whole folder. Keep in mind that the same \code{autorename}
option will be applied to all items.}

\item{preserve_folder_structure}{Logical indicating whether to preserve
folder structure. Set to \code{TRUE} if you want to keep the
exact source folder structure. The default value is \code{TRUE} if the item
being imported is a folder. Should not be used if you are importing a
file. Bear in mind that if you use \code{preserve_folder_structure = FALSE},
the response will be the parent folder object containing imported files
alongside with other files if they exist. Keep in mind that the same
\code{preserve_folder_structure} option will be applied to all folders.}
}
\value{
A list of elements containing information about each file/folder to
be imported.
}
\description{
Utility function to prepare the \code{items} parameter, a list of
elements containing information about each file or folder to be imported
using the \code{bulk_submit_import()} method.
}
\details{
Based on the provided list of \code{\link{VolumeFile}} or
\code{\link{VolumePrefix}} objects, this function allows you to set the
following fields for each item:
\itemize{
\item \code{source_volume}
\item \code{source_location}
\item \code{destination_project} or \code{destination_parent}
\item \code{autorename}
\item \code{preserve_folder_structure}
}

However, keep in mind that there are certain constraints:
\itemize{
\item The same \code{destination_project}/\code{destination_parent} selection
applies to all items in the resulting list.
\item The same applies to \code{autorename} and \code{preserve_folder_structure}
parameters.
\item This function doesn't allow specification of the \code{name} of
aliases to create. This is something that should be specified per
item, therefore it cannot be applied to the entire list. However, once
you have the output of the \code{prepare_items_for_bulk_import} function
you can manually add the \code{name} field to certain items if necessary.
}
}
\examples{
\dontrun{
# Example 1: Prepare 2 items for bulk import action - provide destination
# project
volume_obj_1 <- a$volumes$get
volume_obj_2 <- a$volumes$get

volumes_to_import <- list(volume_obj_1, volume_obj_2)

destination_project <- a$projects$get(id = "project_id")

prepare_items_for_bulk_import(
  volume_items = volumes_to_import,
  destination_project = destination_project
)
}
\dontrun{
# Example 2: Prepare 2 items for bulk import action - provide destination
# parent
volume_obj_1 <- a$volumes$get
volume_obj_2 <- a$volumes$get

volumes_to_import <- list(volume_obj_1, volume_obj_2)

destination_parent <- a$files$get(id = "folder_id")

prepare_items_for_bulk_import(
  volume_items = volumes_to_import,
  destination_parent = destination_parent
)
}

}
\seealso{
\code{\link{Imports}}, \code{\link{VolumeFile}},
\code{\link{VolumePrefix}}
}
