% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sffdr.R
\name{sffdr}
\alias{sffdr}
\title{Estimate the functional p-values, q-values, and local false discovery rates given a set of p-values and
informative variables}
\usage{
sffdr(
  p.value,
  fpi0,
  surrogate = NULL,
  indep_snps = NULL,
  monotone.window = NULL,
  epsilon = 1e-15,
  nn = NULL,
  fp_ties = TRUE,
  ...
)
}
\arguments{
\item{p.value}{A vector of p-values.}

\item{fpi0}{An estimate of the function proportion of null tests using the \code{\link{fpi0est}} function.}

\item{surrogate}{A surrogate variable that compresses more than one informative variables.
Default is NULL. If \code{fpi0} is specified and \code{surrogate} is NULL then \code{fpi0} is used as the surrogate variable.}

\item{indep_snps}{A boolean vector (same size as p) specifying the set of independent tests. Default is NULL and all tests are treated independently.}

\item{monotone.window}{Enforce monotonicity at specified step size. Default is NULL.}

\item{epsilon}{A numerical value the truncation for the p-values during density estimation. Default is 1e-15. You may want to consider decreasing this value if there are a substantial number of small p-values.}

\item{nn}{A numerical value specifying the nearest neighbor parameter in \code{\link{kernelEstimator}}. Default is NULL.}

\item{fp_ties}{A boolean specifying whether ties should be broken using the ordering of the p-values when calculating the fp-values. Only impacts the tests when the local FDR is tied. Default is TRUE.}

\item{\ldots}{Additional arguments passed to \code{\link{kernelEstimator}}.}
}
\value{
A list of object type "sffdr" containing:
\item{pvalues}{A vector of the original p-values.}
\item{fpvalues}{A vector of the estimated functional p-values.}
\item{fqvalues}{A vector of the estimated functional q-values.}
\item{flfdr}{A vector of the estimated functional local FDR values.}
\item{pi0}{An vector of the original functional proportion of null tests.}
\item{density}{An object containing the kernel density estimates from \code{kernelEstimator}.}
}
\description{
Estimate the functional p-values, q-values, and local false discovery rates given a set of p-values and informative
variables. The functional p-values is mapping from the functional q-value (FDR-based measure) to a p-value for type I error rate control.
}
\details{
The function \code{\link{fpi0est}} should be called externally to estimate the
functional proportion of null tests given the set of informative variables.
The surrogate functional FDR methodology builds from the functional FDR
methodology and implements some of the functions from the package.
}
\examples{
\donttest{
# import data
data(bmi)

# separate main p-values and conditioning p-values
p <- sumstats$bmi
z <- as.matrix(sumstats[, -1])

# apply pi0_model to create model
knots <- c(0.005, 0.01, 0.025, 0.05, 0.1)
fmod <- pi0_model(z, knots = knots)

# estimate functional pi0
fpi0_out <- fpi0est(p, z = fmod$zt, pi0_model = fmod$fmod)
fpi0 <- fpi0_out$fpi0

# apply sffdr
# Note all tests are independent see 'indep_snps' argument
# The data has very small p-values, set epsilon to min of p
sffdr_out <- sffdr(p, fpi0, epsilon = min(p))

# Plot significance results
plot(sffdr_out, rng = c(0, 5e-4))

# Functional P-values, Q-values, and local FDR
fp <- sffdr_out$fpvalues
fq <- sffdr_out$fqvalues
flfdr <- sffdr_out$flfdr
}
}
\seealso{
\code{\link{fpi0est}}, \code{\link{plot.sffdr}}
}
\author{
Andrew J. Bass
}
\keyword{sffdr}
