% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/st_quickmap_preds.R
\name{st_quickmap_preds}
\alias{st_quickmap_preds}
\title{Visualise the predictions generated by the `st_augment()` function}
\usage{
st_quickmap_preds(
  output,
  scale_low = "firebrick4",
  scale_mid = "white",
  scale_high = "darkblue",
  scale_midpoint = 0,
  borderwidth = 0.05,
  bordercol = "black",
  legendlimits = "individual",
  titlesize = 12,
  subtitlesize = 10,
  framefill = "white",
  frameline = "black",
  framesize = 1
)
}
\arguments{
\item{output}{an augmented `sf` dataframe produced by `st_augment()`.}

\item{scale_low}{fill of lowest extreme of scale.}

\item{scale_mid}{fill of midpoint of scale.}

\item{scale_high}{fill of highest extreme of scale.}

\item{scale_midpoint}{value of midpoint of scale.}

\item{borderwidth}{linewidth of borders between units.}

\item{bordercol}{colour of borders between units.}

\item{legendlimits}{default `"individual"`. legend of each plot scaled within its own limits. `"minmax"` means all plot have common legend limits according to the global min-max.}

\item{titlesize}{font size for title.}

\item{subtitlesize}{font size for subtitle.}

\item{framefill}{colour for background fill.}

\item{frameline}{colour for frame.}

\item{framesize}{line width of frame.}
}
\value{
A list of ggplots.
}
\description{
Visualise the predictions generated by the `st_augment()` function
}
\examples{
prepdata <- st_bridges(uk_election,"constituency_name")
mgcv::gam(health_not_good ~
  s(constituency_name, bs='mrf', xt=list(nb=prepdata$nb), k=100), data=prepdata, method="REML") |>
st_augment(uk_election) |>
st_quickmap_preds()
}
