% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sigma_shiny.R
\name{sigma_from_igraph}
\alias{sigma_from_igraph}
\title{Build a sgraph object from an igraph object}
\usage{
sigma_from_igraph(
  igraph,
  layout = NULL,
  label_color = "#fff",
  width = "100\%",
  height = "400px",
  elementId = NULL,
  label_grid_cell_size = 200
)
}
\arguments{
\item{igraph}{Igraph object}

\item{layout}{Output of an igraph layout (default: layout_nicely)}

\item{label_color}{Hex color for labels}

\item{width}{Width of the output graph (default: fit container)}

\item{height}{Height of the output graph (default: fit container)}

\item{elementId}{Do not specify, used by the htmlwidgets package}

\item{label_grid_cell_size}{Sigma.js corresponding parameter. Roughly goes
from 1 to 5000, the smaller the more labels 
displayed.}
}
\value{
Htmlwidget object, meant to be called directly to render a default
  visualization, or passed to other functions to change attributes
  (colors, sizes, interactivity, etc.).
}
\description{
Basic sigma.js visualization of an igraph object, with pipeable syntax.
}
\examples{
library(sgraph)
data(lesMis)

sig <- sigma_from_igraph(igraph = lesMis)
sig
}
