% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{plot.naBlocks}
\alias{plot.naBlocks}
\title{Plot Missingness Pattern of Data}
\usage{
\method{plot}{naBlocks}(x, ...)
}
\arguments{
\item{x}{A \code{naBlocks} object.}

\item{...}{Additional parameters passed on to \code{\link[graphics]{rect}}.}
}
\value{
No return value.
}
\description{
Function to visualize the missingness patterns for objects of class \code{naBlocks}.
}
\examples{
    x <- mvtnorm::rmvt(100, toeplitz(seq(1, 0.1, length.out = 3)), df = 5)
    y <- mice::ampute(x, mech='MCAR')$amp
    res <- classicShapeNA(y)
    plot(res$naBlocks)
}
