% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/individual_variable_effect.R
\name{individual_variable_effect}
\alias{individual_variable_effect}
\alias{shap}
\alias{individual_variable_effect.explainer}
\alias{individual_variable_effect.default}
\title{Individual Variable Effect}
\usage{
individual_variable_effect(x, ...)

\method{individual_variable_effect}{explainer}(
  x,
  new_observation,
  method = "KernelSHAP",
  nsamples = "auto",
  ...
)

\method{individual_variable_effect}{default}(
  x,
  data,
  predict_function = predict,
  new_observation,
  label = tail(class(x), 1),
  method = "KernelSHAP",
  nsamples = "auto",
  ...
)

shap(x, ...)
}
\arguments{
\item{x}{a model to be explained, or an explainer created with function \code{\link[DALEX]{explain}}.}

\item{...}{other parameters.}

\item{new_observation}{an observation/observations to be explained. Required for local/instance level
explainers. Columns in should correspond to columns in the data argument. Data set should not contain any additional columns.}

\item{method}{an estimation method of SHAP values. Currently the only availible is `KernelSHAP`.}

\item{nsamples}{number of samples or "auto". Note that number must be as integer. Use `as.integer()`.}

\item{data}{validation dataset. Used to determine univariate distributions, calculation of quantiles,
correlations and so on. It will be extracted from `x` if it’s an explainer.}

\item{predict_function}{predict function that operates on the model `x`. Since the model is a black box,
the `predict_function` is the only interface to access values from the model. It should be a function that
takes at least a model `x` and data and returns vector of predictions. If model response has more than
a single number (like multiclass models) then this function should return a marix/data.frame of the size
`m` x `d`, where `m` is the number of observations while `d` is the dimensionality of model response.
It will be extracted from `x` if it’s an explainer.}

\item{label}{name of the model. By default it’s extracted from the class attribute of the model}
}
\value{
an object of class individual_variable_effect with shap values of each variable for each new observation.
Columns:
\itemize{
  \item first d columns contains variable values.
  \item _id_ - id of observation, number of row in `new_observation` data.
  \item _ylevel_ - level of y
  \item _yhat_ -predicted value for level of y
  \item _yhat_mean_ - expected value of prediction, mean of all predictions
  \item _vname_ - variable name
  \item _attribution_ - attribution of variable
  \item _sign_ a sign of attribution
  \item _label_ a label
}

In order to use shapper with other python virtual environment following R command are required to execute
reticulate::use_virtualenv("path_to_your_env")
or for conda
reticulate::use_conda("name_of_conda_env")
before attaching shapper.
}
\description{
Individual Variable Effect
}
\examples{
have_shap <- reticulate::py_module_available("shap")

if(have_shap){
  library("shapper")
  library("DALEX")
  library("randomForest")
  Y_train <- HR$status
  x_train <- HR[ , -6]
  set.seed(123)
  model_rf <- randomForest(x = x_train, y = Y_train, ntree= 50)
  p_function <- function(model, data) predict(model, newdata = data, type = "prob")

  ive_rf <- individual_variable_effect(model_rf, data = x_train, predict_function = p_function,
                                     new_observation = x_train[1:2,], nsamples = 50)
  ive_rf
} else{
    print('Python testing environment is required.')
}


}
