% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_energy.R
\name{plot_energy}
\alias{plot_energy}
\title{plot_energy}
\usage{
plot_energy(pattern, col = NULL)
}
\arguments{
\item{pattern}{rd_pat or rd_mar object with randomized patterns.}

\item{col}{Vector with colors. Must be the same length as \code{n_random}.}
}
\value{
void
}
\description{
Plot energy of pattern reconstruction
}
\details{
The function plots the decrease of the energy over time, i.e. the iterations.
This can help to identify if the chosen \code{max_runs} for the reconstruction
were sufficient. The \code{pattern} object must have been created using
\code{reconstruct_pattern_*} .
}
\examples{
\dontrun{
pattern_recon <- reconstruct_pattern(species_a, n_random = 3, max_runs = 1000)
plot_energy(pattern_recon)

marks_sub <- spatstat.geom::subset.ppp(species_a, select = dbh)
marks_recon <- reconstruct_pattern_marks(pattern_recon$randomized[[1]], marks_sub,
n_random = 1, max_runs = 1000)
plot_energy(marks_recon)
}

}
\seealso{
\code{\link{reconstruct_pattern}},
\code{\link{fit_point_process}}
}
