% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/decision_trees.R
\name{CART}
\alias{CART}
\title{Classification And Regression Trees}
\usage{
CART(xdata, ydata, Lambda = NULL, family, ...)
}
\arguments{
\item{xdata}{matrix of predictors with observations as rows and variables as
columns.}

\item{ydata}{optional vector or matrix of outcome(s). If \code{family} is set
to \code{"binomial"} or \code{"multinomial"}, \code{ydata} can be a vector
with character/numeric values or a factor.}

\item{Lambda}{matrix of parameters controlling the number of splits in the
decision tree.}

\item{family}{type of regression model. This argument is defined as in
\code{\link[glmnet]{glmnet}}. Possible values include \code{"gaussian"}
(linear regression), \code{"binomial"} (logistic regression),
\code{"multinomial"} (multinomial regression), and \code{"cox"} (survival
analysis).}

\item{...}{additional parameters passed to \code{\link[rpart]{rpart}}.}
}
\value{
A list with: \item{selected}{matrix of binary selection status. Rows
  correspond to different model parameters. Columns correspond to
  predictors.} \item{beta_full}{array of model coefficients. Rows correspond
  to different model parameters. Columns correspond to predictors. Indices
  along the third dimension correspond to outcome variable(s).}
}
\description{
Runs decision trees using implementation from \code{\link[rpart]{rpart}}.
This function is not using stability.
}
\examples{
if (requireNamespace("rpart", quietly = TRUE)) {
  # Data simulation
  set.seed(1)
  simul <- SimulateRegression(pk = 50)

  # Running the LASSO
  mycart <- CART(
    xdata = simul$xdata,
    ydata = simul$ydata,
    family = "gaussian"
  )
  head(mycart$selected)
}
}
\references{
\insertRef{CART}{sharp}
}
\seealso{
\code{\link{SelectionAlgo}}, \code{\link{VariableSelection}}

Other underlying algorithm functions: 
\code{\link{ClusteringAlgo}()},
\code{\link{PenalisedGraphical}()},
\code{\link{PenalisedOpenMx}()},
\code{\link{PenalisedRegression}()}
}
\concept{underlying algorithm functions}
