% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/number_regions.R
\name{number_regions}
\alias{number_regions}
\title{Computes the maximal number of space regions}
\usage{
number_regions(m, n)
}
\arguments{
\item{m}{number of hyperplanes}

\item{n}{space dimensionality}
}
\value{
Maximal number of space regions
}
\description{
This function computes the maximal number of regions an R^n space can
be divided using m hyperplanes
}
\section{References}{
 de Mello, R.F. (2019) "On the Shattering Coefficient of Supervised Learning Algorithms" arXiv:\url{https://arxiv.org/abs/1911.05461}

 de Mello, R.F., Ponti, M.A. (2018, ISBN: 978-3319949888) "Machine Learning: A Practical Approach on the Statistical Learning Theory"

 https://onionesquereality.wordpress.com/2012/11/23/maximum-number-of-regions-in-arrangement-of-hyperplanes/
}

\examples{

number_regions(m=2, n=2)
}
\keyword{analysis}
\keyword{coefficient}
\keyword{complexity}
\keyword{dataset}
\keyword{for}
\keyword{of}
\keyword{shattering}
\keyword{some}
\keyword{the}
