% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/draw_multivari_plot.R
\name{draw_multivari_plot}
\alias{draw_multivari_plot}
\title{Draw Multivari Plot}
\usage{
draw_multivari_plot(
  data,
  y_var,
  grouping_var_1,
  grouping_var_2,
  grouping_var_3,
  grouping_var_4,
  data_point_label = NULL,
  plot_means = FALSE,
  x_axis_text_size = 11,
  panel_text_size = 14,
  point_size = 2.5,
  line_size = 0.7,
  alpha = 0.6
)
}
\arguments{
\item{data}{Input dataset to be plotted (required)}

\item{y_var}{Response variable, Y (required)}

\item{grouping_var_1}{Select column for lowest level grouping variable (required)}

\item{grouping_var_2}{Select column for second level grouping variable (required)}

\item{grouping_var_3}{Select column for third level grouping variable (optional)}

\item{grouping_var_4}{Select column for fourth level grouping variable (optional)}

\item{data_point_label}{Select column to label data points (optional)}

\item{plot_means}{Logical. if FALSE, default, means for mid-level factor are not plotted (optional)}

\item{x_axis_text_size}{Set X axis text size. By default, it is set to 11  (optional)}

\item{panel_text_size}{Set panel text size. By default, it is set to 14 (optional)}

\item{point_size}{Set point size. By default, it is set to 2.5  (optional)}

\item{line_size}{Set line size. By default, it is set to 0.7  (optional)}

\item{alpha}{Set transparency. By default, it is set to 0.6  (optional)}
}
\value{
A 'ggplot' object
}
\description{
Draws a multivari small multiples plot
}
\examples{
library(dplyr)
library(ggh4x)

polar_small_multiples_data \%>\%
  filter(ID_Measurement_Angle \%in\% c(0, 45, 90, 135)) \%>\%
  normalize_observations(y_var = ID,
                         grouping_var = Tip_Bottom,
                         ref_values = c(0.2075, 0.2225)) \%>\%
  draw_multivari_plot(y_var            = ID_normalized,
                     grouping_var_1    = ID_Measurement_Angle,
                     grouping_var_2    = Mold_Cavity_Number,
                     grouping_var_3    = Tip_Bottom,
                     x_axis_text = 6) +
  draw_horizontal_reference_line(reference_line = 0)

}
