% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DBI_connector.R
\docType{class}
\name{RegLogDBIConnector}
\alias{RegLogDBIConnector}
\title{Connector to DBI-valid databases}
\description{
Object of this class handles all connections for the RegLogServer
object to the database. It is created to handle \code{DBI} compatible drivers.
Provides methods than will be used by RegLogServer to get and send data.
}
\seealso{
Other dbConnectors: 
\code{\link{RegLogGsheetConnector}}
}
\concept{dbConnectors}
\section{Super class}{
\code{\link[shiny.reglog:RegLogConnector]{shiny.reglog::RegLogConnector}} -> \code{RegLogDBIConnector}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-RegLogDBIConnector-new}{\code{RegLogDBIConnector$new()}}
\item \href{#method-RegLogDBIConnector-clone}{\code{RegLogDBIConnector$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="shiny.reglog" data-topic="RegLogConnector" data-id="get_logs"><a href='../../shiny.reglog/html/RegLogConnector.html#method-RegLogConnector-get_logs'><code>shiny.reglog::RegLogConnector$get_logs()</code></a></span></li>
<li><span class="pkg-link" data-pkg="shiny.reglog" data-topic="RegLogConnector" data-id="resume"><a href='../../shiny.reglog/html/RegLogConnector.html#method-RegLogConnector-resume'><code>shiny.reglog::RegLogConnector$resume()</code></a></span></li>
<li><span class="pkg-link" data-pkg="shiny.reglog" data-topic="RegLogConnector" data-id="suspend"><a href='../../shiny.reglog/html/RegLogConnector.html#method-RegLogConnector-suspend'><code>shiny.reglog::RegLogConnector$suspend()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RegLogDBIConnector-new"></a>}}
\if{latex}{\out{\hypertarget{method-RegLogDBIConnector-new}{}}}
\subsection{Method \code{new()}}{
Initialization of the object. Creates initial connection
to the database.

Requires \code{DBI} package to be installed.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RegLogDBIConnector$new(
  driver,
  ...,
  table_names = c("account", "reset_code", "logs"),
  custom_handlers = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{driver}}{Call that specifies the driver to be used during all queries}

\item{\code{...}}{other arguments used in \code{DBI::dbConnect()} call}

\item{\code{table_names}}{character vector. Contains names of the tables in the
database: first containing user data, second - reset codes information,
third (optional) - logs from the object. For more info check documentation
of \code{DBI_database_create}.}

\item{\code{custom_handlers}}{named list of custom handler functions. Every
custom handler should take arguments: \code{self} and \code{private} - relating to
the R6 object and \code{message} of class \code{RegLogConnectorMessage}. It should
return \code{RegLogConnectorMessage} object.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
object of \code{RegLogDBIConnector} class
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RegLogDBIConnector-clone"></a>}}
\if{latex}{\out{\hypertarget{method-RegLogDBIConnector-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RegLogDBIConnector$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
