% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lottie_callMethod.R
\name{lottie_callMethod}
\alias{lottie_callMethod}
\title{Call a 'Lottie' Method}
\usage{
lottie_callMethod(
  name = "all",
  method,
  argument = "",
  session = shiny::getDefaultReactiveDomain()
)
}
\arguments{
\item{name}{A character string specifying the name of the 'Lottie' animation to query.
The default of "\code{all}" will retrieve the specified property from all 'Lottie' animations within the 'shiny' application.}

\item{method}{A character string specifying the name of the method to call.}

\item{argument}{A character string specifying any optional arguments to pass to the method.}

\item{session}{The 'shiny' session object. Defaults to the current reactive domain.}
}
\value{
This function is called for a side effect, and so there is no return value.
}
\description{
Call a method for a specific 'Lottie' animation or all 'Lottie' animations.
}
\details{
Sends a custom session message \code{"lottie_js_callMethod"} containing the function arguments.
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
library(shiny)
library(shinyLottie)

ui <- fluidPage(
  include_lottie(),
  lottie_animation(
    path = "shinyLottie/example.json",
    name = "my_animation"
  ),
  actionButton("callMethod", "Call Method (Reverse Direction)")
)

server <- function(input, output, session) {
  observeEvent(input$callMethod, {
    lottie_callMethod(name = "my_animation", method = "setDirection", argument = "-1")
  })
}
shinyApp(ui, server)
\dontshow{\}) # examplesIf}
}
