% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/components.R, R/doc.R
\name{snippet}
\alias{snippet}
\title{snippet}
\usage{
snippet(...)
}
\arguments{
\item{...}{Props to pass to the component.
The allowed props are listed below in the \bold{Details} section.}
}
\value{
An object of class \code{shiny.tag} containing the
necessary configuration and including options such as JavaScript
dependencies to instantiate a HeroUI snippet component.
}
\description{
Snippet is a component that can be used to display inline or multiline code snippets.
}
\details{
\itemize{
\item \bold{children}. Type: \code{ReactNode OR ReactNode[]}. Default: \code{NA}.
\item \bold{size}. Type: \code{sm OR md OR lg}. Default: \code{"md"}.
\item \bold{radius}. Type: \code{none OR sm OR md OR lg}. Default: \code{"lg"}.
\item \bold{symbol}. Type: \code{string OR ReactNode}. Default: \code{"$"}.
\item \bold{timeout}. Type: \code{number}. Default: \code{"2000"}.
\item \bold{codeString}. Type: \code{string}. Default: \code{NA}.
\item \bold{tooltipProps}. Type: \code{TooltipProps}. Default: \code{NA}.
\item \bold{copyIcon}. Type: \code{ReactNode}. Default: \code{NA}.
\item \bold{checkIcon}. Type: \code{ReactNode}. Default: \code{NA}.
\item \bold{disableTooltip}. Type: \code{boolean}. Default: \code{false}.
\item \bold{disableCopy}. Type: \code{boolean}. Default: \code{false}.
\item \bold{hideCopyButton}. Type: \code{boolean}. Default: \code{false}.
\item \bold{hideSymbol}. Type: \code{boolean}. Default: \code{false}.
\item \bold{copyButtonProps}. Type: \code{ButtonProps}. Default: \code{NA}.
\item \bold{disableAnimation}. Type: \code{boolean}. Default: \code{false}.
\item \bold{classNames}. Type: \code{Partial<Record<'base' OR 'content' OR 'pre' OR 'symbol' OR 'copyButton' OR 'checkIcon', string>>}. Default: \code{NA}.
}
\itemize{
\item \bold{onCopy}. Type: \code{(value: string OR string[]) => void}. Default: \code{NA}.
}
}
\examples{
library(shiny)
library(shinyNextUI)
library(shiny.react)

ui <- nextui_page(
  debug_react = TRUE,
  snippet("npm install @nextui-org/react", variant = "bordered"),
  spacer(y = 2),
  snippet("you can't copy me", hideCopyButton = TRUE),
  spacer(y = 2),
  snippet(
    color = "secondary",
    variant = "flat",
    span("npm install @nextui-org/react"),
    span("yarn add @nextui-org/react")
  )
)

server <- function(input, output, session) {

}

if (interactive() || is_testing()) shinyApp(ui, server)
}
\seealso{
See \url{https://heroui.com/docs/components/snippet}.
}
