% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/toastify.R
\name{toastUpdate}
\alias{toastUpdate}
\title{Update a toast}
\usage{
toastUpdate(
  session,
  toastId,
  text,
  type = "default",
  position = "top-right",
  transition = "slide",
  autoClose = 5000,
  hideProgressBar = FALSE,
  closeOnClick = TRUE,
  rtl = FALSE,
  pauseOnFocusLoss = TRUE,
  draggable = TRUE,
  draggableDirection = "x",
  draggablePercent = 80,
  pauseOnHover = TRUE,
  className = NULL,
  toastClassName = NULL,
  bodyClassName = NULL,
  progressClassName = NULL,
  style = NULL,
  JScallback = NULL
)
}
\arguments{
\item{session}{the Shiny \code{session} object}

\item{toastId}{the id of the toast to be updated (\code{id} argument)}

\item{text}{the text displayed in the toast; this can be a character string,
an html element created with the \code{\link[htmltools:HTML]{HTML}}
function, or a \code{shiny.tag} object such as
\code{tags$span(style = "color:lime;", "Message")}}

\item{type}{toast type, one of \code{"info"}, \code{"success"},
\code{"warning"}, \code{"error"}, \code{"default"} or \code{"dark"}}

\item{position}{toast position, one of \code{"top-left"},
\code{"top-right"}, \code{"top-center"}, \code{"bottom-left"},
\code{"bottom-right"} or \code{"bottom-center"}}

\item{transition}{the transition effect, one of \code{"slide"},
\code{"zoom"}, \code{"flip"} or \code{"bounce"}}

\item{autoClose}{either a number, the time in ms to close the toast, or
\code{FALSE} to close the toast manually}

\item{hideProgressBar}{Boolean, whether to hide the progress bar}

\item{closeOnClick}{Boolean, whether to dismiss the toast on click}

\item{rtl}{Boolean, right to left}

\item{pauseOnFocusLoss}{Boolean, whether to pause the toast on focus loss}

\item{draggable}{Boolean, ability to drag the toast to remove it}

\item{draggableDirection}{\code{"x"} or \code{"y"}}

\item{draggablePercent}{the percentage of the width of the toast needed to
remove it by dragging}

\item{pauseOnHover}{Boolean, whether to pause the toast on hover}

\item{className}{name of a CSS class applied to the container}

\item{toastClassName}{name of a CSS class applied on the toast wrapper}

\item{bodyClassName}{name of a CSS class applied on the toast body}

\item{progressClassName}{name of a CSS class applied on the progress bar}

\item{style}{inline style applied to the container, e.g.
\code{list(boxShadow = "rgba(0, 0, 0, 0.56) 0px 22px 30px 4px")}}

\item{JScallback}{some JavaScript code given as a string to be executed
whenever the toast is closed; it will have an effect only if the
\code{position} argument differs from the one of the toast to be
updated}
}
\value{
No return value, called for side effect.
}
\description{
Update a toast in a Shiny application. Run
  \code{shinyToastifyExample("toastUpdate")} for an example.
}
