% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_info.R
\name{get_browser}
\alias{get_browser}
\alias{get_browser_version}
\title{Get user's browser}
\usage{
get_browser()

get_browser_version()
}
\value{
User's detected browser type

User's detected browser version
}
\description{
Get the user's browser name (such as "Chrome" or "Firefox") and version.\cr\cr
The value is reactive, therefore it must be accessed inside a reactive context
(such as an \link[shiny:observe]{observe} or \link[shiny:reactive]{reactive}).\cr\cr
\{shinybrowser\} must be initialized with a call to \code{\link[=detect]{detect()}} in the app's ui.
}
\section{Accuracy}{

It's important to understand there is no reliable way to detect the
information in \{shinybrowser\} with 100\% accuracy.\cr\cr\{shinybrowser\} makes
a best effort at identifying the most accurate information, but some
browser/operating system combinations may be difficult to identify. Users
can also use a variety of tools to deliberately spoof this information.\cr\cr
With that in mind, \{shinybrowser\} should detect the correct information in
most cases.
}

\section{Supported values}{

Only major browsers and operating systems are supported, which means that the
RStudio Viewer may result in an "UNKNOWN" browser, and unpopular operating systems
may also result in "UNKNOWN".\cr\cr
For a list of values that can be detected, see \link{SUPPORTED_BROWSERS},
\link{SUPPORTED_DEVICES}, and \link{SUPPORTED_OPERATING_SYSTEMS}.
}

\examples{
if (interactive()) {
  library(shiny)

  ui <- fluidPage(
    shinybrowser::detect(),
    "Your browser:",
    textOutput("browser_info")
  )
  server <- function(input, output, session) {
    output$browser_info <- renderText({
      paste(shinybrowser::get_browser(), "version", shinybrowser::get_browser_version())
    })
  }
  shinyApp(ui, server)
}
}
\seealso{
\code{\link[=detect]{detect()}}, \code{\link[=get_all_info]{get_all_info()}}, \code{\link[=is_browser_ie]{is_browser_ie()}},
\code{\link[=is_browser_chrome]{is_browser_chrome()}}, \code{\link[=is_browser_firefox]{is_browser_firefox()}}, \link{SUPPORTED_BROWSERS}
}
