% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_info.R
\name{get_width}
\alias{get_width}
\alias{get_height}
\title{Get user's browser dimensions (in pixels)}
\usage{
get_width()

get_height()
}
\value{
User's detected browser width in pixels

User's detected browser height in pixels
}
\description{
The value is reactive, therefore it must be accessed inside a reactive context
(such as an \link[shiny:observe]{observe} or \link[shiny:reactive]{reactive}).\cr\cr
\{shinybrowser\} must be initialized with a call to \code{\link[=detect]{detect()}} in the app's ui.
}
\section{Width and height}{

The width and height of the browser window are only reported once, when the \code{\link[=detect]{detect()}}
function is initially called.
If the user resizes the browser window, the new dimensions are not reported until
the page is refreshed.
}

\examples{
if (interactive()) {
  library(shiny)

  ui <- fluidPage(
    shinybrowser::detect(),
    "Your browser dimensions:",
    textOutput("browser_dim")
  )
  server <- function(input, output, session) {
    output$browser_dim <- renderText({
      paste0(shinybrowser::get_width(), "x", shinybrowser::get_height())
    })
  }
  shinyApp(ui, server)
}
}
\seealso{
\code{\link[=detect]{detect()}}, \code{\link[=get_all_info]{get_all_info()}}
}
