% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/busy-bar.R
\name{add_busy_bar}
\alias{add_busy_bar}
\title{Automatic busy indicator (Progress bar)}
\usage{
add_busy_bar(
  timeout = 1000,
  color = "#112446",
  centered = FALSE,
  height = "8px"
)
}
\arguments{
\item{timeout}{Number of milliseconds after the server is busy to display the progress bar.}

\item{color}{Progress bar color.}

\item{centered}{Center the progress bar or not.}

\item{height}{Height of the bar.}
}
\description{
Make a progress bar appear on top of the page.
}
\examples{
library(shiny)
library(shinybusy)

ui <- fluidPage(

  # Use this function somewhere in UI
  add_busy_bar(color = "#FF0000"),

  headerPanel('Iris k-means clustering'),

  tags$br(),
  actionButton("quick", "Quick calculation (nothing happens)"),
  actionButton("sleep", "Long calculation (progress bar on top)")
)

server <- function(input, output, session) {

  observeEvent(input$quick, {
    Sys.sleep(0.1)
  })

  observeEvent(input$sleep, {
    Sys.sleep(5)
  })

}

if (interactive()) {
  shinyApp(ui, server)
}
}
