% Generated by JSDoc (with jsdoc-r template): do not edit by hand
% Please edit documentation in shinylight-toolkit.js
\docType{package}
\name{toolkit.whenQuiet}
\alias{toolkit.whenQuiet}
\title{JavaScript function: Transforms a function that should not be called too often into
a function that can be called as often as you like.}
\arguments{
\item{ticks}{\code{int} Duration (x 100ms) to wait until calling the
delgate function.}
\item{f}{\code{function} Delegate function to be called
\code{ticks} ticks after the last call to the retuned function.}
}
\value{
Function that can be called often, resulting in fewer
calls to the delegate function \code{f}.
}
\description{
The returned function can be called as often as you like with
whatever arguments you like. If it is called again within
\code{ticks} ticks (a tick is 100ms), this call is ignored. If
it is not called again within this time, the arguments are passed
on to the delegate function. In other words, in a string of calls
less than \code{ticks} x 100ms apart from each other, only
the last of these calls actually happens.
}