% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/constructors.R
\name{set_quiz_options}
\alias{set_quiz_options}
\alias{create_messages}
\title{Set the options for the quiz}
\usage{
set_quiz_options(
  ns = shiny::NS("quiz"),
  messages,
  sandbox = FALSE,
  end_on_first_wrong = !sandbox,
  class = NULL,
  progress_bar = !sandbox,
  progress_bar_color = "#609963",
  ...
)

create_messages(message_correct, message_wrong, message_skipped)
}
\arguments{
\item{ns}{namespace generated from \code{\link[shiny:NS]{shiny::NS()}}. When using custom namespaces, the individual \code{\link[=create_question]{create_question()}} requires the namespace as well.}

\item{messages}{an object of class \code{quizMessages} generated from \code{\link[=create_messages]{create_messages()}} containing the messages to show at the end. If not provided, defaults are used.}

\item{sandbox}{boolean. Quiz no longer ends of the first wrong, removes the progress bar, and grading does not include unattempted questions. Note that the presence of a random question automatically triggers sandbox mode. It can be overridden with \code{set_quiz_options(override = TRUE)}.}

\item{end_on_first_wrong}{Should the quiz immediately end once the user gets one question wrong?}

\item{class}{string. A custom CSS class to add to the quiz div}

\item{progress_bar}{boolean. Show the progress bar UI at the top of the quiz}

\item{progress_bar_color}{Color code for the progress bar background}

\item{...}{other named options to pass to \code{quiz}}

\item{message_correct}{a string to be shown at the end of the quiz when the user gets all questions correct}

\item{message_wrong}{a string to be shown at the end of the quiz when the user gets at least one question wrong}

\item{message_skipped}{a string to be shown at the end of the quiz when the user skips the quiz or ends it early}
}
\value{
a list

an object of class \code{quizMessages}
}
\description{
These are options to be passed to a \code{quiz}.
}
\section{Functions}{
\itemize{
\item \code{set_quiz_options()}: Sets the options for a \code{quiz}

\item \code{create_messages()}: Create a messages object

}}
\examples{
# set the options when creating the quiz
quiz <- create_quiz(
  create_question(
    'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Select nulla.',
    add_choice('auctor'),
    add_choice('nulla', correct = TRUE)
  ),
  create_question(
    'Mauris congue aliquet dui, ut dapibus lorem porttitor sed. Select 600.',
    add_choice('600', correct = TRUE),
    add_choice('800')
  ),
  options = set_quiz_options(sandbox = TRUE)
)

# or modify the options on a quiz object
quiz@options <- set_quiz_options(sandbox = FALSE)

# adjust the messages shown at the end of the quiz
messages <- create_messages(
  'Congrats!',
  'Ahh, bummer! Got at least one wrong',
  'Looks like you skipped to the end!'
 )
quiz@options <- set_quiz_options(messages = messages)
}
