% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/from_igraph.R
\name{sg_from_igraph}
\alias{sg_from_igraph}
\title{Create from igraph}
\usage{
sg_from_igraph(sg, igraph, layout = NULL, sd = NULL)
}
\arguments{
\item{sg}{An object of class \code{sigmajs}as intatiated by \code{\link{sigmajs}}.}

\item{igraph}{An object of class \code{igraph}.}

\item{layout}{A matrix of coordinates.}

\item{sd}{A \link[crosstalk]{SharedData} of nodes.}
}
\value{
A modified version of the \code{sg} object.
}
\description{
Create a \code{sigmajs} from an \code{igraph} object.
}
\examples{
\dontrun{
data("lesmis_igraph")

layout <- igraph::layout_with_fr(lesmis_igraph)

sigmajs() \%>\%
	sg_from_igraph(lesmis_igraph, layout) \%>\%
	sg_settings(defaultNodeColor = "#000")
}

}
